﻿//////////////////////////////////////////////
// ResourceSetLoadQuery.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class ResourceDeclAugmentCallback ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------
	
namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT ResourceSetLoadQuery
	{			
		public :
		
			// Constructor
			ResourceSetLoadQuery () noexcept ;

			// Getters
			nkMemory::StringView getPath () const ;
			ResourceDeclAugmentCallback* getAugmentCallback () const ;
			bool getScene () const ;
			bool getMeshes () const ;
			bool getShaders () const ;
			bool getShaderPrograms () const ;
			bool getCompositors () const ;
			bool getDefaultCompositor () const ;
			bool getRenderQueues () const ;
			bool getSamplers () const ;
			bool getTextures () const ;
			bool getBuffers () const ;
			bool getBlendState () const ;
			bool getDepthStencilState () const ;
			bool getRasterState () const ;
			bool getCameras () const ;

			// Setters
			void setPath (nkMemory::StringView value) ;
			void setAugmentCallback (ResourceDeclAugmentCallback* value) ;
			void setScene (bool value) ;
			void setMeshes (bool value) ;
			void setShaders (bool value) ;
			void setShaderPrograms (bool value) ;
			void setCompositors (bool value) ;
			void setDefaultCompositor (bool value) ;
			void setRenderQueues (bool value) ;
			void setSamplers (bool value) ;
			void setTextures (bool value) ;
			void setBuffers (bool value) ;
			void setBlendState (bool value) ;
			void setDepthStencilState (bool value) ;
			void setRasterState (bool value) ;
			void setCameras (bool value) ;

		private :
		
			// Path
			nkMemory::String _path ;

			// Callbacks
			ResourceDeclAugmentCallback* _augmentCallback ;

			// Ce qu'on veut charger
			// Scène
			bool _scene ;
			// Geometry
			bool _meshes ;
			// Shaders
			bool _shaders ;
			bool _shaderPrograms ;
			// Compositor
			bool _compositors ;
			bool _defaultCompositor ;
			// RQ
			bool _renderQueues ;
			// Textures
			bool _samplers ;
			bool _textures ;
			// Compute Buffers
			bool _computeBuffers ;
			// States
			bool _blendState ;
			bool _depthStencilState ;
			bool _rasterState ;
			// Caméras
			bool _cameras ;
	} ;
}